#include <iostream>
#include <vector>
#include <climits>
using namespace std;

vector<pair<int, int>> make(const int& x1, const int& y1, const int& x2, const int& y2) {
	pair<int, int> dl, dr, ul, ur;
	if (x1 < x2 && y1 << y2) {
		dl = make_pair(x1, y1);
		ul = make_pair(x1, y2);
		dr = make_pair(x2, y1);
		ur = make_pair(x2, y2);
	}
	else {
		dl = make_pair(x2, y2);
		dr = make_pair(x1, y2);
		ul = make_pair(x2, y1);
		ur = make_pair(x1, y1);
	}
	return vector<pair<int, int>> { dl, dr, ul, ur };
}

int main() {
	int n; cin >> n;
	vector<pair<int, int>> cords(n);
	for (int i = 0; i < n; i++) {
		int a, b;
		cin >> a >> b;
		if (a != b && a > 0 && b > 0) {
			cords[i].first = a;
			cords[i].second = b;
		}
	}
	int minz = INT_MAX;
	vector<pair<int, int>> out(4);
	for (int i = 0; i < n - 1; i++) {
		int x1 = cords[i].first;
		int y1 = cords[i].second;
		for (int j = i + 1; j < n; j++) {
			int x2 = cords[j].first;
			int y2 = cords[j].second;
			if ((x1 - x2) + (y1 - y2) < minz) {
				minz = min(minz, (x1 - x2) + (y1 - y2));
				out = make(x1, y1, x2, y2);
			}
		}
	}
	for (int i = 0; i < 4; i++) {
		cout << out[i].first << ' ' << out[i].second << "\n";
	}
	
	return 0;
}